﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class CollectionDifficultyConfiguration : ConfigurationElement
{
    public int DestinationsLowerRange { get; private set; }
    public int DestinationsUpperRange { get; private set; }
    public int MoneyLowerRange { get; private set; }
    public int MoneyUpperRange { get; private set; }
    public int TimePerDestination { get; private set; }

    public CollectionDifficultyConfiguration(string id) : base(id)
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            DestinationsLowerRange = Convert.ToInt32(configElem.Element("DestinationsLowerRange").Value);
            DestinationsUpperRange = Convert.ToInt32(configElem.Element("DestinationsUpperRange").Value);
            MoneyLowerRange = Convert.ToInt32(configElem.Element("MoneyLowerRange").Value);
            MoneyUpperRange = Convert.ToInt32(configElem.Element("MoneyUpperRange").Value);
            TimePerDestination = Convert.ToInt32(configElem.Element("TimePerDestination").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing collection difficulty configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
